unit Main;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls,Editor, Grids, Outline,sysutils;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    Edition: TMenuItem;
    FinEdition: TMenuItem;
    ExitItem: TMenuItem;
    N1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    StatusBar: TPanel;
    SpeedPanel: TPanel;
    Label1: TLabel;
    Button1: TButton;
    Edit1: TEdit;
    Memo1: TMemo;
    ListBox1: TListBox;
    ComboBox1: TComboBox;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    BitBtn1: TBitBtn;
    Shape1: TShape;
    Outline1: TOutline;
    ComboBox2: TComboBox;
    Edit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    Label5: TLabel;
    Edit5: TEdit;
    Button2: TButton;
    Label6: TLabel;
    procedure ShowHint(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure EditionClick(Sender: TObject);
    procedure FinEditionClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure RefreshEditInfo(Sender: TObject);
  end;

var
  MainForm: TMainForm;
  FormEditor: TFormEditor;
implementation

uses About;

{$R *.DFM}

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.Caption := Application.Hint;
end;

procedure TMainForm.ExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.EditionClick(Sender: TObject);
var Exclude:TstringList;
begin
     SpeedPanel.Visible:=True;
     Exclude:=TStringList.Create;
     Exclude.Add('SpeedPanel');
     Exclude.Add('Button2');
     Exclude.Add('ComboBox2');
     Exclude.Add('Edit2');
     Exclude.Add('Edit3');
     Exclude.Add('Edit4');
     Exclude.Add('Edit5');
     Exclude.Add('Label6');
     Exclude.Add('OpenBtn');
     Exclude.Add('SaveBtn');
     Exclude.Add('ExitBtn');
     FormEditor.Edition(Self,Exclude);
     Exclude.free;
end;

procedure TMainForm.FinEditionClick(Sender: TObject);
begin
     if FormEditor.EnEdition then begin
                             FormEditor.FinEdition;
                             SpeedPanel.Visible:=False;
                             end;
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  FormEditor:=TFormEditor.Create(Self);
  FormEditor.OnSelect:=RefreshEditInfo;
  ComboBox2.ItemIndex:=0;
end;

procedure TMainForm.Button2Click(Sender: TObject);
var X, Y, W, H:integer;
    CC1:TCClass;
    NewCtrl:TControl;
begin
if FormEditor.EnEdition then
begin
     X:=StrToInt(Edit2.text);
     Y:=StrToInt(Edit3.text);
     W:=StrToInt(Edit4.text);
     H:=StrToInt(Edit5.text);
     if 0=ComboBox2.ItemIndex then CC1:=TButton;
     if 1=ComboBox2.ItemIndex then CC1:=TComboBox;
     if 2=ComboBox2.ItemIndex then CC1:=TMemo;
     if CC1<>Nil then
        begin
        Newctrl:=FormEditor.NouveauControl(CC1, X, Y, W, H);
        NewCtrl.parent:=self;
        FormEditor.AjouterControl(NewCtrl);
        end;
end;
end;

procedure TMainForm.RefreshEditInfo(Sender: TObject);
begin
with FormEditor do
if EnEdition then
   begin
   if DerNierControlClicke<> Nil then Label6.Caption:='Selected: '+DernierControlClicke.Name
                                 else Label6.Caption:='No Selection';
   end;
end;

end.

